unit Principal;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QComCtrls, QButtons, DB, QGrids, QDBGrids;

type
  TfmPrincipal = class(TForm)
    pgModulos: TPageControl;
    tbClientes: TTabSheet;
    tbFuncionarios: TTabSheet;
    gbServicos: TGroupBox;
    btCalcTotais: TButton;
    btEfetDesconto: TButton;
    btAtuaPedidos: TButton;
    gdClientes: TDBGrid;
    dsClientes: TDataSource;
    edProc: TEdit;
    lbProc: TLabel;
    btProc: TSpeedButton;
    GroupBox1: TGroupBox;
    btFunc: TButton;
    btReaj: TButton;
    cbCountry: TComboBox;
    Label1: TLabel;
    btClienteX: TButton;
    procedure btAtuaPedidosClick(Sender: TObject);
    procedure btEfetDescontoClick(Sender: TObject);
    procedure btCalcTotaisClick(Sender: TObject);
    procedure btProcClick(Sender: TObject);
    procedure edProcKeyPress(Sender: TObject; var Key: Char);
    procedure btReajClick(Sender: TObject);
    procedure btFuncClick(Sender: TObject);
    procedure btClienteXClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmPrincipal: TfmPrincipal;

implementation

uses Data, IClientesIntf, IFuncionariosIntf;

{$R *.xfm}

procedure TfmPrincipal.btAtuaPedidosClick(Sender: TObject);
begin
  with dmData do
  begin
    (HRClientes as IClientes).AtualizarStatusPedido;
    Showmessage('Pedidos atualizados com sucesso!');
    cdsClientes.close;
    cdsClientes.Open;
  end;
end;

procedure TfmPrincipal.btEfetDescontoClick(Sender: TObject);
begin
  with dmData do
  begin
   (HRClientes as IClientes).EfetuarDesconto;
    Showmessage('Desconto efetuado com sucesso!');
    cdsClientes.close;
    cdsClientes.Open;
  end;
end;

procedure TfmPrincipal.btCalcTotaisClick(Sender: TObject);
begin
  with dmData, dsClientes do
  begin
    if not DataSet.IsEmpty then
     Showmessage(Format('Valor total do cliente %s: %f',
      [DataSet.FieldByName('customer').AsString,
       (HRClientes as IClientes).CalcularTotais(DataSet.FieldByName('cust_no').AsInteger)]));
  end;
end;

procedure TfmPrincipal.btProcClick(Sender: TObject);
begin
  with dmData.cdsClientes do
  begin
    close;
    if edProc.Text <> '' then
      params[0].AsString := edProc.Text;
  
    open;
  end;
end;

procedure TfmPrincipal.edProcKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    btProcClick(nil);
end;

procedure TfmPrincipal.btReajClick(Sender: TObject);
begin
  with dmData do
  begin
   (HRFuncionarios as IFuncionarios).ReajusteSalarial;
    Showmessage('Reajuste Salarial efetuado com sucesso!');
  end;
end;

procedure TfmPrincipal.btFuncClick(Sender: TObject);
begin
  with dmData do
    ShowMessage(Format('N de funcionrios do pas %s: %d',
                [cbCountry.Text, (HRFuncionarios as IFuncionarios).NFunc(cbCountry.Text)]));
end;

procedure TfmPrincipal.btClienteXClick(Sender: TObject);
begin
  with dmData do
   ShowMessage((HRClientes as IClientes).ServicoClienteX);
end;

end.
